<?
//-------------------------------------
//-              JCcode               -
//- copyright (c) James Coyle; JCcorp -
//-       developers.JCcorp.net       -
//-        Release 16-07-2007         -
//-            Ver 2.4.3              -
//-------------------------------------

//changelog:

//17-07-2007
//*fix - Strip_tags fixed
//*added - trim all whitespaces
//*added - check for space in email

//29-03-2007
//*fix - added more words to bad words filter
//*fix - name match filter
//*added = strip_tags($vartext) ;

function jc_code($vartext, $moderate_text, $jccode_text, $str_type) {

  $email_match = '/http:|<|:|,| |#/i' ;
  $number_match = '/a|b|c|d|e|f|g|h|i|j|k|l|m|n|o|p|q|r|s|t|u|v|w|x|y|z|.|,|#/i' ;
  $freetext_match = '/<script|<meta/i' ;
  $name_match = '/<|>|_|=|http:|:|,|#/i' ;
  $http_match = '/http:|https:|ftp:|ed2k:/i' ;
  
  $vartext = trim($vartext) ;

  if ($str_type == 'email') {
    $vartext = strip_tags($vartext) ;
    if (!strstr($vartext,"@") || !strstr($vartext,".")) {
	  $vartext = "" ;
    }
	if (preg_match($email_match, $vartext)) {
	  $vartext = "" ;
	}
  }
  
  if ($str_type == 'number') {
    $vartext = strip_tags($vartext) ;
	if (preg_match($number_match, $vartext)) {
	  $vartext = "" ;
	}
  }
  
  if ($str_type == 'http') {
    $vartext = strip_tags($vartext) ;
	if (!preg_match($http_match, $vartext)) {
	  $vartext = "" ;
	}
  }
  
  if ($str_type == 'freetext') {
	if (preg_match($freetext_match, $vartext)) {
	  $vartext = "" ;
	}
  }
  
  if ($str_type == 'name') {
    $vartext = strip_tags($vartext) ;
	if (preg_match($name_match, $vartext)) {
	  $vartext = "" ;
	}
  }


  if ($jccode_text == "on") {
    $vartext = strip_tags($vartext) ;
    $vartext = preg_replace('(\[b\](.+?)\[\/b\])is', '<b>$1</b>', $vartext) ;
    $vartext = preg_replace('(\[i\](.+?)\[\/i\])is', '<i>$1</i>', $vartext) ;
    $vartext = preg_replace('(\[u\](.+?)\[\/u\])is', '<u>$1</u>', $vartext) ;
    $vartext = preg_replace('(\[s\](.+?)\[\/s\])is', '<del>$1</del>', $vartext) ;
    $vartext = preg_replace('(\[size=1\](.+?)\[\/size\])is', '<font size=2>$1</font>', $vartext) ;
    $vartext = preg_replace('(\[size=2\](.+?)\[\/size\])is', '<font size=4>$1</font>', $vartext) ;
    $vartext = preg_replace('(\[size=3\](.+?)\[\/size\])is', '<font size=6>$1</font>', $vartext) ;
    $vartext = preg_replace('/\r\n/', '<br>', $vartext) ;
    $vartext = preg_replace('/:teacher:/', '<img src="images/smilies/0.gif" width="25" height="25" border="0"></a>', $vartext) ;
    $vartext = preg_replace('/:hat:/', '<img src="images/smilies/1.gif" width="25" height="25" border="0"></a>', $vartext) ;
    $vartext = preg_replace('/:bang:/', '<img src="images/smilies/2.gif" width="25" height="25" border="0"></a>', $vartext) ;
    $vartext = preg_replace('/:witch:/', '<img src="images/smilies/3.gif" width="25" height="25" border="0"></a>', $vartext) ;
    $vartext = preg_replace('/:shy:/', '<img src="images/smilies/4.gif" width="25" height="25" border="0"></a>', $vartext) ;
    $vartext = preg_replace('/:blush:/', '<img src="images/smilies/5.gif" width="25" height="25" border="0"></a>', $vartext) ;
    $vartext = preg_replace('/:confused:/', '<img src="images/smilies/6.gif" width="25" height="25" border="0"></a>', $vartext) ;
    $vartext = preg_replace('/:smile:/', '<img src="images/smilies/7.gif" width="25" height="25" border="0"></a>', $vartext) ;
    $vartext = preg_replace('/:cheers:/', '<img src="images/smilies/8.gif" width="58" height="30" border="0"></a>', $vartext) ;
    $vartext = preg_replace('/:beer:/', '<img src="images/smilies/9.gif" width="58" height="30" border="0"></a>', $vartext) ;
	
	
	
	$vartext = preg_replace('/:sm1:/', '<img src="images/smilies/1.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm2:/', '<img src="images/smilies/2.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm3:/', '<img src="images/smilies/3.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm4:/', '<img src="images/smilies/4.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm5:/', '<img src="images/smilies/5.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm6:/', '<img src="images/smilies/6.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm7:/', '<img src="images/smilies/7.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm8:/', '<img src="images/smilies/8.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm9:/', '<img src="images/smilies/9.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm10:/', '<img src="images/smilies/10.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm11/', '<img src="images/smilies/11.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm12:/', '<img src="images/smilies/12.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm13:/', '<img src="images/smilies/13.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm14:/', '<img src="images/smilies/14.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm15:/', '<img src="images/smilies/15.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm16:/', '<img src="images/smilies/16.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm17:/', '<img src="images/smilies/17.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm18:/', '<img src="images/smilies/18.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm19:/', '<img src="images/smilies/19.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm20:/', '<img src="images/smilies/20.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm21:/', '<img src="images/smilies/21.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm22:/', '<img src="images/smilies/22.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm23:/', '<img src="images/smilies/23.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm24:/', '<img src="images/smilies/24.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm25:/', '<img src="images/smilies/25.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm26:/', '<img src="images/smilies/26.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm27:/', '<img src="images/smilies/27.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm28:/', '<img src="images/smilies/28.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm29:/', '<img src="images/smilies/29.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm30:/', '<img src="images/smilies/30.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm31:/', '<img src="images/smilies/31.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm32:/', '<img src="images/smilies/32.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm33:/', '<img src="images/smilies/33.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm34:/', '<img src="images/smilies/34.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm35:/', '<img src="images/smilies/35.png" width="24" height="24" border="0"></a>', $vartext) ;
	$vartext = preg_replace('/:sm36:/', '<img src="images/smilies/36.png" width="24" height="24" border="0"></a>', $vartext) ;
	
  }

  if ($moderate_text == "on") {
    $vartext = preg_replace('/knobhead|fuck|shit|bastard|wank|bollux|twat|cunt|prick|bollucks|wanker|fucking|twated|bastards|cunts|twats/i', '*****', $vartext) ;
  }

  return $vartext ;
}